﻿const hiddenApplyToAllSwitch = "[name='MfaSettings.MfaApplyToAllUserGroups'][type='hidden']";
const checkBoxApplyToAll = "[name='MfaSettings.MfaApplyToAllUserGroups'][type='checkbox']";

$("[name='MfaSettings.MfaActive']").on("click", function (e) {
    toggleButtons(e);
});

$(hiddenApplyToAllSwitch).prop("value", $(checkBoxApplyToAll).prop("checked"));
$(checkBoxApplyToAll).on("change", function () {
    $(hiddenApplyToAllSwitch).prop("value", $(checkBoxApplyToAll).prop("checked"));
});

function toggleButtons(e) {
    if (e.target.value === "False") {
        $(checkBoxApplyToAll).prop({ "disabled": true, "checked": true });
        $(hiddenApplyToAllSwitch).prop("value", true);
    } else { 
        $(checkBoxApplyToAll).prop("disabled", false);
    }
}

var authenticationSettings = {
    context: $(".v-authenticationSettings"),
    initialize: function () {
        var self = this;

        var altValueField = $("#MfaSettings_MfaOutgoingMailConfigurationId", self.context);
        if (altValueField) {
            var altValue = altValueField.val();
            if (altValue) {
                self.initializeMfaSenderEmailAddressAutocomplete(altValue);
            }
        }

        $(".h-mfaOutgoingMailConfiguration-autocomplete", self.context).a4autocomplete({
            ajaxAction: a4.getAction("GetOutgoingMailConfigurationsForAutoComplete", "Distribute", "Survey", { surveyId: 0 }),
            valueProperty: "Id",
            labelProperty: "DisplayName",
            altValueField: altValueField,
            required: true,
            select: function (event, data) {
                if (data.item) {
                    self.initializeMfaSenderEmailAddressAutocomplete(data.item.Id);
                }
            }
        });

        $(".h-mfaSenderEmailAddress-autocomplete", self.context).on("change", function (event) {
            if ($(this).val()) {
                $(".h-mfaSenderName", self.context).removeAttr("placeholder");
            }
            else {
                $(".h-mfaSenderName", self.context).attr("placeholder", function () {
                    return $(this).attr("data-placeholder");
                });
            }
        });
    },
    initializeMfaSenderEmailAddressAutocomplete: function (outgoingMailConfigurationId) {
        $(".h-mfaSenderEmailAddress-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSenderEmailAddressesForAutoComplete", "Distribute", "Survey", { outgoingMailConfigurationId: outgoingMailConfigurationId }),
            validateSelection: false
        });
    }
}

$(document).ready(function () {
    if (authenticationSettings.context.length > 0) {
        authenticationSettings.initialize();
    }
});